#pragma once

#include "GLStubs.h"
#include "ICleanable.h"
#include "ICleanableObserver.h"

class Uniform : public ICleanable
{
public:
    Uniform(GLint location, ICleanableObserver *observer)
        : m_location(location),
          m_currentValue(0.0f),
          m_dirty(true),
          m_observer(observer)
    {
        m_observer->NotifyDirty(this);
    }

    float GetValue() const
    {
        return m_currentValue;
    }

    void SetValue(float value)
    {
        if (!m_dirty && (m_currentValue != value))
        {
            m_dirty = true;
            m_observer->NotifyDirty(this);
        }

        m_currentValue = value;
    }

private:
    // ICleanable Implementation
    virtual void Clean()
    {
        glUniform1f(m_location, m_currentValue);
        m_dirty = false;
    }

private:
    GLint m_location;
    GLfloat m_currentValue;
    bool m_dirty;
    ICleanableObserver *m_observer;
};
