#pragma once

#include <string>
#include <vector>
#include <map>
#include <algorithm>

#include "GLStubs.h"
#include "ICleanable.h"
#include "ICleanableObserver.h"
#include "Uniform.h"

class ShaderProgram : public ICleanableObserver
{
public:
    ShaderProgram(const std::string& vertexSource, const std::string& fragmentSource)
    {
        m_handle = glCreateProgram();
        // ... Create, compile, and link shader objects

        // TODO: populate
        m_uniforms["diffuseIntensity"] = new Uniform(0, this);
        m_uniforms["specularIntensity"] = new Uniform(1, this);
    }

    virtual ~ShaderProgram()
    {
        // Delete shader objects, shader program, and uniforms allocated in the constructor

        // ... Delete shader objects, etc 
        glDeleteProgram(m_handle);

        for (NameToUniform::iterator i = m_uniforms.begin(); i != m_uniforms.end(); ++i)
        {
            delete i->second;
        }
    }

    Uniform *GetUniformByName(const std::string name)
    {
        NameToUniform::iterator i = m_uniforms.find(name);
        
        return (i != m_uniforms.end()) ? i->second : 0;
    }

    void Clean()
    {
        std::for_each(m_dirtyUniforms.begin(), m_dirtyUniforms.end(), 
            std::mem_fun(&ICleanable::Clean));

        m_dirtyUniforms.clear();
    }

    // ICleanableObserver Implementation
    virtual void NotifyDirty(ICleanable *value)
    {
        m_dirtyUniforms.push_back(value);
    }

private:
    typedef std::map<std::string, Uniform *> NameToUniform;

    GLuint m_handle;
    std::vector<ICleanable *> m_dirtyUniforms;
    NameToUniform m_uniforms;
};
